-- Legacy UI: not localized?

rollout px_d6Panel_connection "Connection"  category:1
(
	label         lbl1_ui       "Parent: "           align:#left across:3 offset:[0, 4] 
	pickbutton    body0_ui      "undefined"          align:#left toolTip:"Specify Parent" autoDisplay: true width:62
	button		  rembody0_ui	"x"					 align:#right toolTip:"Remove Parent"
	label         lbl2_ui       "Child: "            align:#left across:3 offset:[0, 4]
	pickbutton    body1_ui      "undefined"          align:#left toolTip:"Specify Child" autoDisplay: true width:62
	button		  rembody1_ui	"x"					 align:#right toolTip:"Remove Child"
		
	checkbox      breakable_ui  "Breakable"         checked:false
	label         maxForce_lb   "Max Force"         align:#left  across:2 offset:[6, 0]
	spinner       maxForce_ui   ""                  align:#right range:[0.01,PxMaxValue,0.01] type:#float width:50 
	label         maxTorque_lb  "Max Torque"        align:#left  across:2 offset:[6, 0]
	spinner       maxTorque_ui  ""                  align:#right range:[0.01,PxMaxValue,0.01] type:#float width:50
	
	local break_values = #()
	local break_state = 0
	
	on body0_ui picked obj do
	(
		undo "Edit Constraint(s) connection body0 edit" on
		(
			for i in pxSelectedHelpers do
				i.body0 = obj
		)
	)
	
	on body1_ui picked obj do
	(
		undo "Edit Constraint(s) connection body1 edit" on
		(
			for i in pxSelectedHelpers do
				i.body1 = obj
		)
	)
	
	on rembody0_ui pressed do
	(
		PxStopSimulation()
		undo "Edit Constraint(s) connection remove body0" on
		(
			for i in pxSelectedHelpers do
				i.body0_ui.object = undefined;
		)
	)
	
	on rembody1_ui pressed do
	(
		PxStopSimulation()
		undo "Edit Constraint(s) connection remove body1" on
		(
			for i in pxSelectedHelpers do
				i.body1_ui.object = undefined;
		)
	)
	
	on breakable_ui changed value do
	(
		undo "Edit Constraint(s) connection breakable edit" on
		(
			if (break_values.count > 0) then
			(
				break_state = (integer)(mod (break_state + 1) 3)
				breakable_ui.tristate = break_state
			)
			
			if (break_state == 2) then
			(
				total = break_values.count
				for i = 1 to total do
					pxSelectedHelpers[i].breakable  = break_values[i]					
			)
			else
			(
				for i in pxSelectedHelpers do
					i.breakable  = breakable_ui.checked
			)
		)
	)

	on maxForce_ui changed value do
	(
		undo "Edit Constraint(s) connection max force edit" on
		(
			for i in pxSelectedHelpers do
				i.maxForce  = value
		)
	)

	on maxTorque_ui changed value do
	(
		undo "Edit Constraint(s) connection max torque edit" on
		(
			for i in pxSelectedHelpers do
				i.maxTorque  = value
		)
	)
	
	fn loadValues =
	(
		body0_uiOk = true
		body1_uiOk = true
		breakable_uiOk = true
		maxForce_uiOk = true
		maxTorque_uiOk = true 
		
		break_values = #()
		for i in pxSelectedHelpers do
		(
			append break_values i.breakable
			
			if (i.body0 !=  pxSelectedHelpers[1].body0) then body0_uiOk = false
			if (i.body1 !=  pxSelectedHelpers[1].body1) then body1_uiOk = false

			if (i.breakable !=  pxSelectedHelpers[1].breakable) then breakable_uiOk = false

			if (not close_enough i.maxForce pxSelectedHelpers[1].maxForce 10) then	maxForce_uiOk = false
			if (not close_enough i.maxTorque pxSelectedHelpers[1].maxTorque 10) then maxTorque_uiOk = false
		)
		
		if body0_uiOk then (
			--if pxSelectedHelpers[1].body0 == undefined then body0_ui.text = "(none)"  else body0_ui.text = pxSelectedHelpers[1].body0.name
			body0_ui.object = pxSelectedHelpers[1].body0
		) else (
			body0_ui.text = ""
		)

		if body1_uiOk then (
			--if pxSelectedHelpers[1].body1 == undefined then body1_ui.text = "(none)"  else body1_ui.text = pxSelectedHelpers[1].body1.name
			body1_ui.object = pxSelectedHelpers[1].body1
		) else (
			body1_ui.text = ""
		)
		
		if breakable_uiOk then (
			breakable_ui.checked = pxSelectedHelpers[1].breakable
			break_values = #()
		) else (
			breakable_ui.triState = 2
		)
		break_state = breakable_ui.triState

		if maxForce_uiOk then  maxForce_ui.value = pxSelectedHelpers[1].maxForce  else  maxForce_ui.indeterminate = true
		if maxTorque_uiOk then  maxTorque_ui.value = pxSelectedHelpers[1].maxTorque  else  maxTorque_ui.indeterminate = true
	)
	
	on px_d6Panel_connection open do
	(
		loadValues()
	)
)

rollout px_d6Panel_translation "Translation Limits" category:2
(
	label         lbl_t0            "Locked   Limited  Free"    align:#right
	label         lbl_t1            "X"                         align:#left  across:2
	radiobuttons  x_range           ""                          labels:#("      ", "      ", "      ")  width:100 columns:3 align:#right default:0
	label         lbl_t2            "Y"                         align:#left  across:2
	radiobuttons  y_range           ""                          labels:#("      ", "      ", "      ")  width:100 columns:3 align:#right default:0
	label         lbl_t3            "Z"                         align:#left  across:2
	radiobuttons  z_range           ""                          labels:#("      ", "      ", "      ")  width:100 columns:3 align:#right default:0

	label         lbl_t4            "Limit Radius"              align:#left  across:2 offset:[0, 1]
	spinner       linear_ui_position  ""             range:[0,PxMaxValue,0] scale:0.05 type:#float align:#right width:60
	label         lbl_t5            "Bounce"                    align:#left  across:2 offset:[0, 1]
	spinner       linear_ui_rest    ""          range:[0, 1, 0] scale:0.05 type:#float  align:#right width:60
	label         lbl_t6            "Spring"                    align:#left  across:2 offset:[0, 1]
	spinner       linear_ui_spring  ""               range:[0,PxMaxValue,0] scale:0.05 type:#float align:#right width:60
	label         lbl_t7            "Damping"                   align:#left  across:2 offset:[0, 1]
	spinner       linear_ui_damp    ""              range:[0,1000,0] scale:0.05 type:#float align:#right width:60
	
	fn updateEnableState =
	(
		local state = (x_range.state != 1) or (y_range.state != 1) or (z_range.state != 1)
		lbl_t4.enabled = state
		lbl_t5.enabled = state
		lbl_t6.enabled = state
		lbl_t7.enabled = state
		linear_ui_position.enabled = state
		linear_ui_rest.enabled = state
		linear_ui_spring.enabled = state
		linear_ui_damp.enabled = state
	)
	
	on x_range changed state do
	(
		undo "Edit Constraint(s) translation x mode edit" on
		(
			updateEnableState()
			for i in pxSelectedHelpers do
				i.linearModeX = state
		)
	)		

	on y_range changed state do
	(
		undo "Edit Constraint(s) translation y mode edit" on
		(
			updateEnableState()
			for i in pxSelectedHelpers do
				i.linearModeY = state
		)
	)		
	
	on z_range changed state do
	(
		undo "Edit Constraint(s) translation z mode edit" on
		(
			updateEnableState()
			for i in pxSelectedHelpers do
				i.linearModeZ = state
		)
	)		
	
	on linear_ui_position changed value do
	(
		undo "Edit Constraint(s) translation limit radius edit" on
		(
			for i in pxSelectedHelpers do
			i.linearPosition = value
		)
	)

	on linear_ui_rest changed value do
	(
		undo "Edit Constraint(s) translation bounce edit" on
		(
			for i in pxSelectedHelpers do
			i.linearRestitution = value
		)
	)
	
	on linear_ui_spring changed value do
	(
		undo "Edit Constraint(s) translation spring edit" on
		(
			for i in pxSelectedHelpers do
			i.linearSpring = value
		)
	)

	on linear_ui_damp changed value do
	(
		undo "Edit Constraint(s) translation damping edit" on
		(
			for i in pxSelectedHelpers do
			i.linearDamping = value
		)
	)
	
	fn loadValues =
	(
		xtemp = pxSelectedHelpers[1].linearModeX
		xOk = true
		ytemp = pxSelectedHelpers[1].linearModeY
		yOk = true
		ztemp = pxSelectedHelpers[1].linearModeZ
		zOk = true
		
		linear_ui_positionOk = true
		linear_ui_restOk = true
		linear_ui_springOk = true
		linear_ui_dampOk = true
		
		updateEnableState()
		
		for i in pxSelectedHelpers do
		(	
			if (i.linearModeX != xtemp) then
				xOk = false			

			if (i.linearModeY != ytemp) then
				yOk = false	

			if (i.linearModeZ != ztemp) then
				zOk = false	
			
			if (not close_enough i.linearPosition pxSelectedHelpers[1].linearPosition 10) then  linear_ui_positionOk = false
			if (not close_enough i.linearRestitution pxSelectedHelpers[1].linearRestitution 10) then linear_ui_restOk = false
			if (not close_enough i.linearSpring pxSelectedHelpers[1].linearSpring 10) then linear_ui_springOk = false
			if (not close_enough i.linearDamping pxSelectedHelpers[1].linearDamping 10) then linear_ui_dampOk = false
		)
		if linear_ui_positionOk then linear_ui_position.value = pxSelectedHelpers[1].linearPosition else linear_ui_position.indeterminate = true
		if linear_ui_restOk then linear_ui_rest.value = pxSelectedHelpers[1].linearRestitution else linear_ui_rest.indeterminate = true
		if linear_ui_springOk then linear_ui_spring.value = pxSelectedHelpers[1].linearSpring else linear_ui_spring.indeterminate = true
		if linear_ui_dampOk then linear_ui_damp.value = pxSelectedHelpers[1].linearDamping else linear_ui_damp.indeterminate = true
		
		x_range.state = 0
		if xOk then
			x_range.state = xtemp
		
		y_range.state = 0
		if yOk then
			y_range.state = ytemp
		
		z_range.state = 0		
		if zOk then
			z_range.state = ztemp
	)
	
	on px_d6Panel_translation open do
	(
		loadValues()
	)
)

rollout px_d6Panel_swingtwist "Swing & Twist Limits" category:3
(
	group "Swing Y"
	(
		label         lbl_s10           "Locked      Limited      Free  "    align:#right
		radiobuttons  swing1_mode       ""   labels:#("          ", "        ", "  ") width:130 columns:3 align:#right default:0

		label         lbl_s11           "Angle Limit"                                   align:#left  across:2
		spinner       swing1_ui_angle   ""   range:[0,180,0] scale:0.5 type:#float  align:#right width:60
		label         lbl_s12           "Bounce"                                        align:#left  across:2
		spinner       swing1_ui_rest    ""   range:[0, 1, 0] scale:0.5 type:#float     align:#right width:60
		label         lbl_s13           "Spring"                                        align:#left  across:2
		spinner       swing1_ui_spring  ""   range:[0,PxMaxValue,0] scale:0.05 type:#float  align:#right width:60
		label         lbl_s14           "Damping"                                       align:#left  across:2
		spinner       swing1_ui_damp    ""   range:[0,PxMaxValue,0] scale:0.05 type:#float    align:#right width:60
	)

	group "Swing Z"
	(
		label         lbl_s20           "Locked      Limited      Free  "    align:#right
		radiobuttons  swing2_mode       ""   labels:#("          ", "        ", "  ") width:130 columns:3 align:#right default:0

		label         lbl_s21           "Angle Limit"                                   align:#left  across:2
		spinner       swing2_ui_angle   ""   range:[0,180,0] scale:0.5 type:#float     align:#right width:60
		label         lbl_s22           "Bounce"                                        align:#left  across:2
		spinner       swing2_ui_rest    ""   range:[0, 1, 0] scale:0.5 type:#float     align:#right width:60
		label         lbl_s23           "Spring"                                        align:#left  across:2
		spinner       swing2_ui_spring  ""   range:[0,PxMaxValue,0] scale:0.05 type:#float  align:#right width:60
		label         lbl_s24           "Damping"                                       align:#left  across:2
		spinner       swing2_ui_damp    ""   range:[0,PxMaxValue,0] scale:0.05 type:#float    align:#right width:60
	)
		
	group "Twist"
	(
		label         lbl_tw0           "Locked      Limited      Free  "    align:#right
		radiobuttons  twist_mode        ""   labels:#("          ", "        ", "  ") width:130 columns:3 align:#right default:0
		
		label         twist_lbl0        "Left          Right     "    align:#right
		label         twist_lbl1        "Limit"                       align:#left  across:3
		spinner       twist_angle_low   ""                            align:#right range:[-180,180,0] scale:0.5 type:#float width:45
		spinner       twist_angle_high  ""                            align:#right range:[-180,180,0] scale:0.5 type:#float width:45 
		label         twist_lbl2        "Bounce"                      align:#left  across:3
		spinner       twist_rest_low    ""                            align:#right range:[0,1,0] scale:0.05 type:#float width:45
		spinner       twist_rest_high   ""                            align:#right range:[0,1,0] scale:0.05 type:#float width:45 
		label         twist_lbl3        "Spring"                      align:#left  across:3
		spinner       twist_spring_low  ""                            align:#right range:[0,PxMaxValue,0] scale:0.05 type:#float width:45
		spinner       twist_spring_high ""                            align:#right range:[0,PxMaxValue,0] scale:0.05 type:#float width:45
		label         twist_lbl4        "Damping"                     align:#left  across:3
		spinner       twist_damp_low    ""                            align:#right range:[0,PxMaxValue,0] scale:0.05 type:#float width:45
		spinner       twist_damp_high   ""                            align:#right range:[0,PxMaxValue,0] scale:0.05 type:#float width:45 
	)
	
	fn updateSwing1EnableState =
	(
		local state = (swing1_mode.state != 1)
		lbl_s11.enabled = state
		lbl_s12.enabled = state
		lbl_s13.enabled = state
		lbl_s14.enabled = state
		swing1_ui_angle.enabled = state
		swing1_ui_rest.enabled = state
		swing1_ui_spring.enabled = state
		swing1_ui_damp.enabled = state
	)
		
	fn updateSwing2EnableState =
	(
		local state = (swing2_mode.state != 1)
		lbl_s21.enabled = state
		lbl_s22.enabled = state
		lbl_s23.enabled = state
		lbl_s24.enabled = state
		swing2_ui_angle.enabled = state
		swing2_ui_rest.enabled = state
		swing2_ui_spring.enabled = state
		swing2_ui_damp.enabled = state
	)
		
	fn updateTwistEnableState =
	(
		local state = (twist_mode.state != 1)
		twist_lbl0.enabled = state
		twist_lbl1.enabled = state
		twist_lbl2.enabled = state
		twist_lbl3.enabled = state
		twist_lbl4.enabled = state
		twist_angle_low.enabled = state
		twist_angle_high.enabled = state
		twist_rest_low.enabled = state
		twist_rest_high.enabled = state
		twist_spring_low.enabled = state
		twist_spring_high.enabled = state
		twist_damp_low.enabled = state
		twist_damp_high.enabled = state
	)	
	
	on twist_mode changed state do
	(
		undo "Edit Constraint(s) twist mode edit" on
		(
			updateTwistEnableState()
			for i in pxSelectedHelpers do
				i.twistMode = state
		)
	)	

	on twist_angle_low changed value do
	(
		undo "Edit Constraint(s) twist angle low edit" on
		(
			for i in pxSelectedHelpers do
				i.twistAngleLow = value
		)
	)

	on twist_angle_high changed value do
	(
		undo "Edit Constraint(s) twist angle high edit" on
		(
			for i in pxSelectedHelpers do
			i.twistAngleHigh = value
		)
	)
	
	on twist_rest_low changed value do
	(
		undo "Edit Constraint(s) twist rest low edit" on
		(
			for i in pxSelectedHelpers do
				i.twistRestitutionLow = value
		)
	)
	
	on twist_rest_high changed value do
	(
		undo "Edit Constraint(s) twist rest high edit" on
		(
			for i in pxSelectedHelpers do
				i.twistRestitutionHigh = value
		)
	)	
	
	on twist_spring_low changed value do
	(
		undo "Edit Constraint(s) twist spring low edit" on
		(
			for i in pxSelectedHelpers do
				i.twistSpringLow = value
		)
	)	
	
	on twist_spring_high changed value do
	(
		undo "Edit Constraint(s) twist spring high edit" on
		(
			for i in pxSelectedHelpers do
				i.twistSpringHigh = value
		)
	)		

	on twist_damp_low changed value do
	(
		undo "Edit Constraint(s) twist damp low edit" on
		(
			for i in pxSelectedHelpers do
				i.twistDampingLow = value
		)
	)	
	
	on twist_damp_high changed value do
	(
		undo "Edit Constraint(s) twist damp high edit" on
		(
			for i in pxSelectedHelpers do
				i.twistDampingHigh = value
		)
	)		

	on swing1_mode changed state do
	(
		undo "Edit Constraint(s) swing1 mode edit" on
		(
			updateSwing1EnableState()
			for i in pxSelectedHelpers do
				i.swing1Mode = state
		)
	)	

	on swing1_ui_angle changed value do
	(
		undo "Edit Constraint(s) swing1 angle edit" on
		(
			for i in pxSelectedHelpers do
				i.swing1Angle = value
		)
	)

	on swing1_ui_rest changed value do
	(
		undo "Edit Constraint(s) swing1 bounce edit" on
		(
			for i in pxSelectedHelpers do
				i.swing1Restitution = value
		)
	)
	
	on swing1_ui_spring changed value do
	(
		undo "Edit Constraint(s) swing1 spring edit" on
		(
			for i in pxSelectedHelpers do
				i.swing1Spring = value
		)
	)
	
	on swing1_ui_damp changed value do
	(
		undo "Edit Constraint(s) swing1 damp edit" on
		(
			for i in pxSelectedHelpers do
				i.swing1Damping = value
		)
	)
	
	on swing2_mode changed state do
	(
		undo "Edit Constraint(s) swing2 mode edit" on
		(
			updateSwing2EnableState()
			for i in pxSelectedHelpers do
				i.swing2Mode = state
		)
	)	

	on swing2_ui_angle changed value do
	(
		undo "Edit Constraint(s) swing2 angle edit" on
		(
			for i in pxSelectedHelpers do
			i.swing2Angle = value
		)
	)

	on swing2_ui_rest changed value do
	(
		undo "Edit Constraint(s) swing2 bounce edit" on
		(
			for i in pxSelectedHelpers do
				i.swing2Restitution = value
		)
	)
	
	on swing2_ui_spring changed value do
	(
		undo "Edit Constraint(s) swing2 spring edit" on
		(
			for i in pxSelectedHelpers do
				i.swing2Spring = value
		)
	)
	
	on swing2_ui_damp changed value do
	(
		undo "Edit Constraint(s) swing2 damp edit" on
		(
			for i in pxSelectedHelpers do
				i.swing2Damping = value
		)
	)	
	
	fn loadValues =
	(
		s1temp = pxSelectedHelpers[1].swing1Mode
		s1ok = true
		swing1_ui_angleOk = true 
		swing1_ui_restOk = true 
		swing1_ui_springOk = true 
		swing1_ui_dampOk = true 

		s2temp = pxSelectedHelpers[1].swing2Mode
		s2ok = true
		swing2_ui_angleOk = true 
		swing2_ui_restOk = true 
		swing2_ui_springOk = true 
		swing2_ui_dampOk = true 

		twistTemp = pxSelectedHelpers[1].twistMode
		twistOk = true
		twist_angle_lowOk = true 
		twist_angle_highOk = true 
		twist_rest_lowOk = true 
		twist_rest_highOk = true 
		twist_spring_lowOk = true 
		twist_spring_highOk = true 
		twist_damp_lowOk = true 
		twist_damp_highOk = true 
		
		updateSwing1EnableState()
		updateSwing2EnableState()
		updateTwistEnableState()
		
		for i in pxSelectedHelpers do
		(	
			if (i.swing1Mode !=  s1temp) then
				s1ok = false
			
			if (not close_enough i.swing1Angle pxSelectedHelpers[1].swing1Angle 10) then  swing1_ui_angleOk = false
			if (not close_enough i.swing1Restitution pxSelectedHelpers[1].swing1Restitution 10) then  swing1_ui_restOk = false
			if (not close_enough i.swing1Spring pxSelectedHelpers[1].swing1Spring 10) then  swing1_ui_springOk = false
			if (not close_enough i.swing1Damping pxSelectedHelpers[1].swing1Damping 10) then  swing1_ui_dampOk = false

			if (i.swing2Mode !=  s2temp) then
				s2ok = false
			
			if (not close_enough i.swing2Angle pxSelectedHelpers[1].swing2Angle 10) then swing2_ui_angleOk = false
			if (not close_enough i.swing2Restitution pxSelectedHelpers[1].swing2Restitution 10) then swing2_ui_restOk = false
			if (not close_enough i.swing2Spring pxSelectedHelpers[1].swing2Spring 10) then swing2_ui_springOk = false
			if (not close_enough i.swing2Damping pxSelectedHelpers[1].swing2Damping 10) then swing2_ui_dampOk = false
				
			if (i.twistMode !=  twistTemp) then
				twistOk = false

			if (not close_enough i.twistAngleLow pxSelectedHelpers[1].twistAngleLow 10) then twist_angle_lowOk = false
			if (not close_enough i.twistAngleHigh pxSelectedHelpers[1].twistAngleHigh 10) then twist_angle_highOk = false
			if (not close_enough i.twistRestitutionLow pxSelectedHelpers[1].twistRestitutionLow 10) then twist_rest_lowOk = false
			if (not close_enough i.twistRestitutionHigh pxSelectedHelpers[1].twistRestitutionHigh 10) then twist_rest_highOk = false
			if (not close_enough i.twistSpringLow pxSelectedHelpers[1].twistSpringLow 10) then twist_spring_lowOk = false
			if (not close_enough i.twistSpringHigh pxSelectedHelpers[1].twistSpringHigh 10) then twist_spring_highOk = false
			if (not close_enough i.twistDampingLow pxSelectedHelpers[1].twistDampingLow 10) then twist_damp_lowOk = false
			if (not close_enough i.twistDampingHigh pxSelectedHelpers[1].twistDampingHigh 10) then twist_damp_highOk = false
		)
		
		if swing1_ui_angleOk then  swing1_ui_angle.value = pxSelectedHelpers[1].swing1Angle  else swing1_ui_angle.indeterminate = true
		if swing1_ui_restOk then  swing1_ui_rest.value = pxSelectedHelpers[1].swing1Restitution  else swing1_ui_rest.indeterminate = true
		if swing1_ui_springOk then swing1_ui_spring.value = pxSelectedHelpers[1].swing1Spring  else swing1_ui_spring.indeterminate = true
		if swing1_ui_dampOk then swing1_ui_damp.value = pxSelectedHelpers[1].swing1Damping  else swing1_ui_damp.indeterminate = true

		if swing2_ui_angleOk then swing2_ui_angle.value = pxSelectedHelpers[1].swing2Angle  else swing2_ui_angle.indeterminate = true
		if swing2_ui_restOk then swing2_ui_rest.value = pxSelectedHelpers[1].swing2Restitution  else swing2_ui_rest.indeterminate = true
		if swing2_ui_springOk then swing2_ui_spring.value = pxSelectedHelpers[1].swing2Spring  else swing2_ui_spring.indeterminate = true
		if swing2_ui_dampOk then swing2_ui_damp.value = pxSelectedHelpers[1].swing2Damping  else swing2_ui_damp.indeterminate = true

		if twist_angle_lowOk then twist_angle_low.value = pxSelectedHelpers[1].twistAngleLow  else twist_angle_low.indeterminate = true
		if twist_angle_highOk then twist_angle_high.value = pxSelectedHelpers[1].twistAngleHigh  else twist_angle_high.indeterminate = true
		if twist_rest_lowOk then twist_rest_low.value = pxSelectedHelpers[1].twistRestitutionLow  else twist_rest_low.indeterminate = true
		if twist_rest_highOk then twist_rest_high.value = pxSelectedHelpers[1].twistRestitutionHigh  else twist_rest_high.indeterminate = true
		if twist_spring_lowOk then twist_spring_low.value = pxSelectedHelpers[1].twistSpringLow  else twist_spring_low.indeterminate = true
		if twist_spring_highOk then twist_spring_high.value = pxSelectedHelpers[1].twistSpringHigh  else twist_spring_high.indeterminate = true
		if twist_damp_lowOk then twist_damp_low.value = pxSelectedHelpers[1].twistDampingLow  else twist_damp_low.indeterminate = true
		if twist_damp_highOk then twist_damp_high.value = pxSelectedHelpers[1].twistDampingHigh  else twist_damp_high.indeterminate = true
		
		swing1_mode.state = 0
		if s1ok then
			swing1_mode.state = s1temp
		
		swing2_mode.state = 0
		if s2ok then
			swing2_mode.state = s2temp
		
		twist_mode.state = 0
		if twistOk then
			twist_mode.state = twistTemp
	)
	
	on px_d6Panel_swingtwist open do
	(
		loadValues()
	)
)

rollout px_d6Panel_spring "Spring" category:4
(
	group "Spring to Resting Position"
	(
		label         lbl_spp01       "Springness"         align:#left  across:2
		spinner       posSpring_ui    ""                   align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
		label         lbl_spp02       "Damping"            align:#left  across:2
		spinner       posDamping_ui   ""                   align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
	)
		
	group "Spring to Resting Swing"
	(
		label         lbl_sps01        "Springness"         align:#left  across:2
		spinner       swingSpring_ui   ""                   align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
		label         lbl_sps02        "Damping"            align:#left  across:2
		spinner       swingDamping_ui  ""                   align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
	)
		
	group "Spring to Resting Twist"
	(
		label         lbl_spt01        "Springness"         align:#left  across:2
		spinner       twistSpring_ui   ""                   align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
		label         lbl_spt02        "Damping"            align:#left  across:2
		spinner       twistDamping_ui  ""                   align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
	)
	
	on posSpring_ui changed value do
	(
		undo "Edit Constraint(s) spring  StRP springness edit" on
		(
			for i in pxSelectedHelpers do
				i.posSpring = value
		)
	)

	on posDamping_ui changed value do
	(
		undo "Edit Constraint(s) spring  StRP damping edit" on
		(
			for i in pxSelectedHelpers do
				i.posDamping = value
		)
	)

	on swingSpring_ui changed value do
	(
		undo "Edit Constraint(s) spring  StRS springness edit" on
		(
			for i in pxSelectedHelpers do
				i.swingSpring = value
		)
	)

	on swingDamping_ui changed value do
	(
		undo "Edit Constraint(s) spring  StRS damping edit" on
		(
			for i in pxSelectedHelpers do
				i.swingDamping = value
		)
	)

	on twistSpring_ui changed value do
	(
		undo "Edit Constraint(s) spring  StRT springness edit" on
		(
			for i in pxSelectedHelpers do
				i.twistSpring = value
		)
	)

	on twistDamping_ui changed value do
	(
		undo "Edit Constraint(s) spring  StRT damping edit" on
		(
			for i in pxSelectedHelpers do
				i.twistDamping = value
		)
	)
	
	fn loadValues =
	(
		posSpring_uiOk = true
		posDamping_uiOk = true
		swingSpring_uiOk = true
		swingDamping_uiOk = true
		twistSpring_uiOk = true
		twistDamping_uiOk = true
		
		for i in pxSelectedHelpers do
		(			
			if (not close_enough i.posSpring pxSelectedHelpers[1].posSpring 10) then posSpring_uiOk = false
			if (not close_enough i.posDamping pxSelectedHelpers[1].posDamping 10) then posDamping_uiOk = false

			if (not close_enough i.swingSpring pxSelectedHelpers[1].swingSpring 10) then swingSpring_uiOk = false
			if (not close_enough i.swingDamping pxSelectedHelpers[1].swingDamping 10) then swingDamping_uiOk = false

			if (not close_enough i.twistSpring pxSelectedHelpers[1].twistSpring 10) then twistSpring_uiOk = false
			if (not close_enough i.twistDamping pxSelectedHelpers[1].twistDamping 10) then twistDamping_uiOk = false
		)
		
		if posSpring_uiOk then posSpring_ui.value = pxSelectedHelpers[1].posSpring  else posSpring_ui.indeterminate = true
		if posDamping_uiOk then posDamping_ui.value = pxSelectedHelpers[1].posDamping  else posDamping_ui.indeterminate = true
		if swingSpring_uiOk then swingSpring_ui.value = pxSelectedHelpers[1].swingSpring  else swingSpring_ui.indeterminate = true
		if swingDamping_uiOk then swingDamping_ui.value = pxSelectedHelpers[1].swingDamping  else swingDamping_ui.indeterminate = true
		if twistSpring_uiOk then twistSpring_ui.value = pxSelectedHelpers[1].twistSpring  else twistSpring_ui.indeterminate = true
		if twistDamping_uiOk then twistDamping_ui.value = pxSelectedHelpers[1].twistDamping  else twistDamping_ui.indeterminate = true
	)
	
	on px_d6Panel_spring open do
	(
		loadValues()
	)
)

rollout px_d6Panel_advanced "Advanced" category:5
(
	button    moveToParent  "Move to Parent's Pivot" width:120
	button    moveToChild   "Move to Child's Pivot"  width:120
		
	label     lbl_h1		   "Display Size"  align:#left  across:2
	spinner   helpersize_ui       "" range: [0.001,1000,0.001] type: #float align:#right width:60
		
	checkbox  collision_ui     "Parent/Child Collision" checked:false
	checkbox  gearing_ui       "Parent Turns Child"     checked:false
	label     gearratio_lb     "Gear Ratio"             align:#right across:2
	spinner   gearratio_ui     ""                       align:#right type:#float range:[-PxMaxValue, PxMaxValue, 1] width:60

	checkbox      useProj_ui    "Use Projection"    align:#left
	radiobuttons  projmode_ui   ""                  labels:#("Linear Only (faster)  ", "Linear and Angular  ")  width:120 columns:1 align:#right default:0
	label         projdist_lb   "Distance"          align:#right across:2    width:50
	spinner       projdist_ui   ""                  align:#right type:#float width:60
	label         projangle_lb  "Angle"             align:#right across:2    width:50
	spinner       projangle_ui  ""                  align:#right type:#float width:60
	
	local col_values = #()
	local col_statePrev = 0
	local gearing_values = #()
	local gearing_statePrev = 0
	local proj_values = #()
	local proj_statePrev = 0
	
	fn updateEnableProjectionState =
	(
		local state = useProj_ui.checked
		projmode_ui.enabled = state
		projdist_lb.enabled = state
		projdist_ui.enabled = state
		projangle_lb.enabled = state
		projangle_ui.enabled = state
	)	
	
	fn updateEnableGearState =
	(
		local state = gearing_ui.checked
		gearratio_lb.enabled = state
		gearratio_ui.enabled = state
	)	
	
	on moveToParent pressed do
	(
		undo "Edit Constraint(s) spring  move to parent" on
		(
			for i in pxSelectedHelpers do
				if i.body0 != undefined then try(i.pos = i.body0.pos) catch()
		)
	)

	on moveToChild pressed do
	(
		undo "Edit Constraint(s) spring  move to child" on
		(
			for i in pxSelectedHelpers do
				if i.body1 != undefined then try(i.pos = i.body1.pos) catch()
		)
	)

	on helpersize_ui changed val do
	(
		undo "Edit Constraint(s) advanced helpersize edit" on
		(
			for i in pxSelectedHelpers do
				i.helpersize = val
		)
	)
			
	on gearing_ui   changed value do
	(		
		undo "Edit Constraint(s) advanced turns child edit" on
		(
			if (gearing_values.count > 0) then
			(
				if (gearing_statePrev == 2) then gearing_statePrev = 0 else gearing_statePrev = gearing_statePrev + 1
				gearing_ui.tristate = gearing_statePrev
			)

			if (gearing_statePrev == 2) then
			(
				total = gearing_values.count
				for i = 1 to total do
					pxSelectedHelpers[i].gearing  = gearing_values[i]
			)
			else
			(
				for i in pxSelectedHelpers do
					i.gearing = gearing_ui.checked
			)			

			updateEnableGearState();
		)
	)

	on useProj_ui   changed value do
	(
		undo "Edit Constraint(s) advanced use projection" on
		(
			if (proj_values.count > 0) then
			(
				if proj_statePrev == 2 then proj_statePrev = 0 else proj_statePrev = proj_statePrev + 1
				useProj_ui.tristate = proj_statePrev
			)
			
			if (proj_statePrev == 2) then
			(
				total = proj_values.count
				for i = 1 to total do
					pxSelectedHelpers[i].useProjection  = proj_values[i]
			)
			else
			(
				for i in pxSelectedHelpers do
					i.useProjection = useProj_ui.checked
			)

			updateEnableProjectionState();
		)
	)

	fn refreshCollision = 
	(
		if (col_values.count > 0) then
		(
			if col_statePrev == 2 then col_statePrev = 0 else col_statePrev = col_statePrev + 1
			collision_ui.tristate = col_statePrev
		)
		
		if (col_statePrev == 2) then
		(
			total = col_values.count
			for i = 1 to total do
				pxSelectedHelpers[i].collision  = col_values[i]
		)
		else
		(
			for i in pxSelectedHelpers do
				i.collision = collision_ui.checked
		)
	)
	
	on collision_ui   changed value do
	(
		undo "Edit Constraint(s) advanced collision" on
		(
			refreshCollision()
		)
	)
	
	on gearratio_ui   changed value do
	(
		undo "Edit Constraint(s) advanced collision" on
		(
			for i in pxSelectedHelpers do
				i.gearRatio = value
		)
	)
	
	on projmode_ui   changed value do
	(
		undo "Edit Constraint(s) advanced proj mode" on
		(
			for i in pxSelectedHelpers do
				i.projectionMode = value
		)
	)

	on projdist_ui   changed value do
	(
		undo "Edit Constraint(s) advanced proj dist" on
		(
			for i in pxSelectedHelpers do
				i.projectionDist = value
		)
	)

	on projangle_ui   changed value do
	(
		undo "Edit Constraint(s) advanced proj angle" on
		(
			for i in pxSelectedHelpers do
				i.projectionAngle = value
		)
	)	
	
	fn loadValues =
	(
		collision_uiOk = true 
		
		gearing_uiOk = true 
		
		helpersize_uiOk = true
		gearratio_uiOk = true
		
		useProj_uiOk = true
		projModeTemp = pxSelectedHelpers[1].projectionMode
		projModeOk = true
		projdist_uiOk = true
		projangle_uiOk = true
		
		col_values = #()
		gearing_values = #()
		proj_values = #()
		for i in pxSelectedHelpers do
		(
			append col_values i.collision
			append gearing_values i.gearing
			append proj_values i.useProjection
			
			if (i.collision !=  pxSelectedHelpers[1].collision) then collision_uiOk = false
			if (i.gearing !=  pxSelectedHelpers[1].gearing) then gearing_uiOk = false
			if (i.useProjection !=  pxSelectedHelpers[1].useProjection) then useProj_uiOk = false
			
			if (i.projectionMode !=  projModeTemp) then
				projModeOk = false
			
			if (not close_enough i.helpersize pxSelectedHelpers[1].helpersize 10) then helpersize_uiOk = false
			
			if (not close_enough i.gearRatio pxSelectedHelpers[1].gearRatio 10) then gearratio_uiOk = false

			if (not close_enough i.projectionDist pxSelectedHelpers[1].projectionDist 10) then projdist_uiOk = false
			if (not close_enough i.projectionAngle pxSelectedHelpers[1].projectionAngle 10) then projangle_uiOk = false
		)

		if collision_uiOk then (
			collision_ui.checked = pxSelectedHelpers[1].collision
			col_values = #()
		) else (
			collision_ui.tristate = 2
		)
		col_statePrev = collision_ui.tristate
		
		if helpersize_uiOk then helpersize_ui.value = pxSelectedHelpers[1].helpersize  else helpersize_ui.indeterminate = true
		
		if gearing_uiOk then (
			gearing_ui.checked = pxSelectedHelpers[1].gearing
			gearing_values = #()
		) else (
			gearing_ui.tristate = 2
		)
		gearing_statePrev = gearing_ui.tristate
		
		if gearratio_uiOk then gearratio_ui.value = pxSelectedHelpers[1].gearRatio  else gearratio_ui.indeterminate = true
		
		if useProj_uiOk then (
			useProj_ui.checked = pxSelectedHelpers[1].useProjection
			proj_values = #()
		) else (
			useProj_ui.tristate = 2
		)
		proj_statePrev = useProj_ui.tristate
		
		if projdist_uiOk then projdist_ui.value = pxSelectedHelpers[1].projectionDist  else projdist_ui.indeterminate = true
		if projangle_uiOk then projangle_ui.value = pxSelectedHelpers[1].projectionAngle  else projangle_ui.indeterminate = true
		
		projmode_ui.state = 0
		if projModeOk then
			projmode_ui.state = projModeTemp
		
		updateEnableGearState()
		updateEnableProjectionState()
	)
	
	on px_d6Panel_advanced open do
	(
		loadValues()	
	)
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCIxgTlrSBgKAEwEPdFJd7bD7JnDbLXCa+M
-- tY1IXdVo0gMOHX+W5TLi52+P2XEzBYvaCAgBVW7LQWwggps2KEiozTgUBVCwTVL0
-- /I2HtxyVgRPnd0WEuvlR/KxYH25weEV02RiUC6HWDNYK7RQovHyp/9hT5wG4p0Fh
-- RDOeuN0/2nYn3SnPeyv3wkzjxqmx44VHdMZfUOmmzzkrz9qNYvGbSUi5++J9EbO4
-- vdmLvlrJN2Y6BAMj6AC/gP+9XXzOGs2ULuAvK9usUXDEr+0OG/GZSanS3ZV5oNfj
-- NQe+KCl8U6bzd/vFMuNL+emenwun67oljfLhQeV/QFKe8/5KIdsN
-- -----END-SIGNATURE-----